/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.item;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.jobs.CraftingTypeDictionary;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.CraftingType;
import technology.rocketjump.undermount.jobs.model.JobType;

@Singleton
public class ItemTypeDictionary {
    private Map<String, ItemType> byName = new HashMap<String, ItemType>();
    private List<ItemType> allTypesList = new ArrayList<ItemType>();
    private Map<CraftingType, List<ItemType>> byCraftingType = new HashMap<CraftingType, List<ItemType>>();

    @Inject
    public ItemTypeDictionary(CraftingTypeDictionary craftingTypeDictionary, ProfessionDictionary professionDictionary) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        File itemTypeJsonFile = new File("assets/definitions/itemTypes.json");
        List itemTypeList = (List)objectMapper.readValue(FileUtils.readFileToString(itemTypeJsonFile, "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, ItemType.class));
        for (ItemType itemType : itemTypeList) {
            if (itemType.getRelatedCraftingTypeNames() == null) {
                itemType.setRelatedCraftingTypeNames(new ArrayList<String>());
            }
            if (itemType.getRelatedCraftingTypes() == null) {
                itemType.setRelatedCraftingTypes(new ArrayList<CraftingType>());
            }
            for (String relatedCraftingName : itemType.getRelatedCraftingTypeNames()) {
                CraftingType craftingType = craftingTypeDictionary.getByName(relatedCraftingName);
                if (craftingType == null) {
                    System.err.println("Could not find related crafting type by name: " + relatedCraftingName + " for " + itemType.getItemTypeName());
                    continue;
                }
                itemType.getRelatedCraftingTypes().add(craftingType);
                List<ItemType> itemTypesByCraftingType = this.byCraftingType.get(craftingType);
                if (itemTypesByCraftingType == null) {
                    itemTypesByCraftingType = new ArrayList<ItemType>();
                    this.byCraftingType.put(craftingType, itemTypesByCraftingType);
                }
                itemTypesByCraftingType.add(itemType);
            }
            this.byName.put(itemType.getItemTypeName(), itemType);
            this.allTypesList.add(itemType);
        }
        JobType.HAULING.setProfession(ProfessionDictionary.NULL_PROFESSION);
        JobType.MINING.setProfession(professionDictionary.getByName("MINER"));
        JobType.MINING.setItemTypeRequiredForWork(this.getByName("Tool-Pickaxe"));
        JobType.LOGGING.setProfession(professionDictionary.getByName("LUMBERJACK"));
        JobType.LOGGING.setItemTypeRequiredForWork(this.getByName("Tool-Axe"));
        JobType.CONSTRUCT_STONE_FURNITURE.setProfession(professionDictionary.getByName("STONEMASON"));
        JobType.CONSTRUCT_STONE_FURNITURE.setItemTypeRequiredForWork(this.getByName("Tool-Chisel"));
        JobType.CONSTRUCT_WOODEN_FURNITURE.setProfession(professionDictionary.getByName("CARPENTER"));
        JobType.CONSTRUCT_WOODEN_FURNITURE.setItemTypeRequiredForWork(this.getByName("Tool-Saw"));
        JobType.CRAFT_AT_WORKSTATION.setProfession(ProfessionDictionary.SPECIFIC_PROFESSION_REQUIRED);
        JobType.COLLECT_ITEM.setProfession(ProfessionDictionary.SPECIFIC_PROFESSION_REQUIRED);
        JobType.CLEAR_GROUND.setProfession(ProfessionDictionary.NULL_PROFESSION);
    }

    public ItemType getByName(String itemTypeName) {
        return this.byName.get(itemTypeName);
    }

    public List<ItemType> getAll() {
        return this.allTypesList;
    }

    public List<ItemType> getByCraftingType(CraftingType craftingType) {
        return this.byCraftingType.get(craftingType);
    }
}

